using System;
using System.IO;
using DynaPDF;

namespace examples
{
	class Class1
	{
      /*
         Note that the dynapdf.dll must be copied into the output directory or into a
         Windwos search path (e.g. %WINDOWS%/System32) before the application can be executed!
      */

      // Error callback function.
      // If the function name should not appear at the beginning of the error message then set
      // the flag emNoFuncNames (pdf.SetErrorMode(DynaPDF.TErrMode.emNoFuncNames);).
      static int PDFError(IntPtr Data, int ErrCode, IntPtr ErrMessage, int ErrType)
      {
         Console.Write("{0}\n", System.Runtime.InteropServices.Marshal.PtrToStringAnsi(ErrMessage));
         return 0; // We try to continue if an error occurrs. Any other return value breaks processing.
      }

		[STAThread]
		static void Main(string[] args)
		{
         try
         {
            CPDF pdf = new CPDF();
            // Error messages and warnings are passed to the callback function.
            pdf.SetOnErrorProc(IntPtr.Zero, new DynaPDF.TErrorProc(PDFError));
            pdf.CreateNewPDF(null); // We open the output file later if no error occurrs.

            pdf.SetPageCoords(TPageCoord.pcTopDown);

            pdf.Append();
               pdf.SetFont("Helvetica", TFStyle.fsRegular, 14.0, false, TCodepage.cp1252);
               pdf.WriteFTextEx(50.0, 50.0, pdf.GetPageWidth() - 100.0, -1.0, TTextAlign.taJustify,
                  "The following pages were imported from different PDF files. DynaPDF adjusts the destinations of link annotations and bookmarks so that "+
                  "all destinations refer to the new page numbers after import.\n\n"+
                  "Entire PDF files can be easily merged with ImportPDFFile() but it is also possible to import only specific pages of an arbitrary number "+
                  "of PDF files. You can also add further pages or edit imported pages if necessary. An existing page can be opened for editing with EditPage().");
            pdf.EndPage();

            bool first        = true;
            int  destPage     = 1;
            bool haveXFA      = false;
            bool isCollection = false;

            String[] files = {"../../../../license.pdf", "../../../../dynapdf_help.pdf"};

            // Generic code to merge arbitrary PDF files.
            for (int i = 0; i < 2; i++)
            {
               if (pdf.OpenImportFile(files[i], TPwdType.ptOpen, null) < 0)
               {
                  pdf = null;
                  return;
               }
               /*
                  Not all PDF files can be merged:
                     - An Interactive Form is a global structure that cannot be simply merged. The names of all form fields must be
                       be unique. But also if name collusions will be solved, there is no guarantee that embedded Javascripts or Javascript
                       actions will work as expected. Interactive Forms should not be merged!

                     - A PDF collection is a special PDF file that consists of a container PDF and an array of embedded files.
                       It is possible to merge two or more PDF Collections but it is not meaningful to merge a PDF Collection
                       with normal PDF files or vice versa.
               */
               if (first)
               {
                  first        = false;
                  haveXFA      = pdf.GetInIsXFAForm();
                  isCollection = pdf.GetInIsCollection();
                  if ((destPage = pdf.ImportPDFFile(destPage + 1, 1.0, 1.0)) < 0) break;
               }else
               {
                  // Special handling for PDF Collections
                  if (isCollection)
                  {
                     if (pdf.GetInIsCollection())
                     {
                        // Import the embedded files only
                        pdf.SetImportFlags(TImportFlags.ifEmbeddedFiles);
                        // We could also use ImportPDFFile() but this function is more efficient since no pages will be imported.
                        if (!pdf.ImportCatalogObjects()) break;
                     }else
                     {
                        pdf.CloseImportFile();
                        // Add the file to the collection
                        pdf.AttachFile(files[i], Path.GetFileName(files[i]), true);
                     }
                  }else
                  {
                     if (pdf.GetInIsCollection() || ((pdf.GetInIsXFAForm() || pdf.GetInFieldCount() > 0) && (pdf.GetFieldCount() > 0 || haveXFA))) break;
                     pdf.SetImportFlags(TImportFlags.ifImportAll | TImportFlags.ifImportAsPage); // Import anything and avoid the conversion of pages to templates
                     pdf.SetImportFlags2(TImportFlags2.if2UseProxy);                             // This flag reduces the memory usage.
                     if ((destPage = pdf.ImportPDFFile(destPage + 1, 1.0, 1.0)) < 0) break;
                  }
               }
               pdf.CloseImportFile();
            }

            // No fatal error occurred?
            if (pdf.HaveOpenDoc())
            {
               // We write the output file into the current directory.
               String filePath = Directory.GetCurrentDirectory() + "\\out.pdf";
               // OK, now we can open the output file.
               if (!pdf.OpenOutputFile(filePath)) return;
               if (pdf.CloseFile())
               {
                  Console.Write("PDF file \"{0}\" successfully created!\n", filePath);
                  System.Diagnostics.Process p = new System.Diagnostics.Process();
                  p.StartInfo.FileName = filePath;
                  p.Start();
               }
            }
            pdf = null;
         }catch(Exception e)
         {
            Console.Write(e.Message);
            Console.Read();
         }
		}
	}
}
